<?xml version="1.0" encoding="utf-8" ?>
<!-- *******************************************************************
Copyright (c) Microsoft Corporation.  All rights reserved.
******************************************************************** -->

<Configuration>


  <SelectionSets>
    <SelectionSet>
      <Name>RegisteredServerTypes</Name>
      <Types>
        <TypeName>Microsoft.SqlServer.Management.RegisteredServers.ServerGroup</TypeName>
        <TypeName>Microsoft.SqlServer.Management.RegisteredServers.RegisteredServer</TypeName>
      </Types>
    </SelectionSet>
  </SelectionSets>

  <!-- ################ GLOBAL CONTROL DEFINITIONS ################ -->
  <Controls>
    <Control>
      <Name>RegisteredServerTypes-GroupingFormat</Name>
      <CustomControl>
        <CustomEntries>
          <CustomEntry>
            <CustomItem>
              <Frame>
                <LeftIndent>4</LeftIndent>
                <CustomItem>
                  <Text>Directory: </Text>
                  <ExpressionBinding>
                    <ScriptBlock>$_.PSParentPath</ScriptBlock>
                  </ExpressionBinding>
                  <NewLine/>
                </CustomItem>
              </Frame>
            </CustomItem>
          </CustomEntry>
        </CustomEntries>
      </CustomControl>
    </Control>
  </Controls>



  <ViewDefinitions>

    <!-- SMO -->

    <View>
      <Name>Server</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Server</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>80</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

	  <View>
		  <Name>Database</Name>
		  <ViewSelectedBy>
			  <TypeName>Microsoft.SqlServer.Management.Smo.Database</TypeName>
		  </ViewSelectedBy>
		  <TableControl>
			  <TableHeaders>

				  <TableColumnHeader>
					  <Label>Name</Label>
					  <Width>20</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Status</Label>
					  <Width>15</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Containment Type</Label>
					  <Width>16</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Recovery Model</Label>
					  <Width>14</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>CompatLvl</Label>
					  <Width>9</Width>
					  <Alignment>right</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Collation</Label>
					  <Width>30</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

				  <TableColumnHeader>
					  <Label>Owner</Label>
					  <Width>25</Width>
					  <Alignment>left</Alignment>
				  </TableColumnHeader>

			  </TableHeaders>
			  <TableRowEntries>
				  <TableRowEntry>
					  <Wrap/>
					  <TableColumnItems>

						  <TableColumnItem>
							  <PropertyName>Name</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>Status</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>ContainmentType</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>RecoveryModel</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <ScriptBlock>
								  [int] $_.CompatibilityLevel
							  </ScriptBlock>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>Collation</PropertyName>
						  </TableColumnItem>

						  <TableColumnItem>
							  <PropertyName>Owner</PropertyName>
						  </TableColumnItem>

					  </TableColumnItems>
				  </TableRowEntry>
			  </TableRowEntries>
		  </TableControl>
	  </View>

    <View>
      <Name>Table</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Table</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>View</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.View</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>StoredProcedure</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.StoredProcedure</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>User</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.User</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Login</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Login</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Login</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Login</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>45</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Login Type</Label>
            <Width>13</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>LoginType</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ServerRole</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.ServerRole</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Fixed Role</Label>
            <Width>11</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Owner</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Modified</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsFixedRole</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.DateCreated.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Owner</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.DateModified.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>Sequence</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Sequence</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>CurrentValue</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        
          <TableColumnHeader>
            <Label>IsExhausted</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Owner</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Modified</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>


              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>CurrentValue</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsExhausted</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Owner</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.DateLastModified.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
<!--end sequence-->

    <View>
      <Name>Schema</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Schema</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Owner</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Owner</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Index</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Index</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>80</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Trigger</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.Trigger</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>UserDefinedFunction</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.UserDefinedFunction</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Schema</Label>
            <Width>28</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Schema</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>SystemMessage</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.SystemMessage</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Language</Label>
            <Width>15</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Text</Label>
            <Width>58</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Language</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Text</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>UserDefinedMessage</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.UserDefinedMessage</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Language</Label>
            <Width>15</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Text</Label>
            <Width>58</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Language</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Text</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <!-- DMF -->

    <View>
      <Name>PolicyStore</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.PolicyStore</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>80</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Policy</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.Policy</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Category</Label>
            <Width>17</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Enabled</Label>
            <Width>7</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PolicyCategory</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Enabled</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>EvaluationHistory</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.EvaluationHistory</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Policy Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Result</Label>
            <Width>6</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Start Date</Label>
            <Width>18</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>End Date</Label>
            <Width>18</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Messages</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>
              
              <TableColumnItem>
                <PropertyName>PolicyName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Result</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.StartDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.EndDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Exception</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ConnectionEvaluationHistory</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.ConnectionEvaluationHistory</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Server Instance</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Result</Label>
            <Width>6</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Messages</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>ServerInstance</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Result</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Exception</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    
    <View>
      <Name>EvaluationDetail</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.EvaluationDetail</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Result</Label>
            <Width>6</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Query Expression</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Messages</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Result</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetQueryExpression</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>Exception</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TargetSet</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.TargetSet</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Type Skeleton</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Enabled</Label>
            <Width>5</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetType</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetTypeSkeleton</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Enabled</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    
    <View>
      <Name>TargetSetLevel</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.TargetSetLevel</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Condition</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Type Skeleton</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Level Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Condition</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetTypeSkeleton</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>LevelName</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>Condition</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.Condition</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Facet</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Created</Label>
            <Width>22</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Facet</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.CreateDate.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>PolicyCategory</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.PolicyCategory</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Mandate Database Subscriptions</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>MandateDatabaseSubscriptions</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>PolicyCategorySubscription</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.PolicyCategorySubscription</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>5</Width>
            <Alignment>right</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Policy Category</Label>
            <Width>23</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target</Label>
            <Width>23</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Target Type</Label>
            <Width>23</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PolicyCategory</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Target</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TargetType</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>ObjectSet</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Dmf.ObjectSet</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Facet</Label>
            <Width>25</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Facet</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <!-- SQL Server Registrations -->

    <View>
      <Name>children</Name>
      <ViewSelectedBy>
        <SelectionSetName>RegisteredServerTypes</SelectionSetName>
      </ViewSelectedBy>
      <GroupBy>
        <PropertyName>PSParentPath</PropertyName>
        <CustomControlName>RegisteredServerTypes-GroupingFormat</CustomControlName>
      </GroupBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Mode</Label>
            <Width>4</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Mode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    <View>
      <Name>children</Name>
      <ViewSelectedBy>
        <SelectionSetName>RegisteredServerTypes</SelectionSetName>
      </ViewSelectedBy>
      <GroupBy>
        <PropertyName>PSParentPath</PropertyName>
        <CustomControlName>RegisteredServerTypes-GroupingFormat</CustomControlName>
      </GroupBy>
      <ListControl>
        <ListEntries>
          <ListEntry>
            <EntrySelectedBy>
              <TypeName>Microsoft.SqlServer.Management.RegisteredServers.ServerGroup</TypeName>
            </EntrySelectedBy>
            <ListItems>
              <ListItem>
                <PropertyName>DisplayName</PropertyName>
              </ListItem>
            </ListItems>
          </ListEntry>
          <ListEntry>
            <ListItems>
              <ListItem>
                <PropertyName>DisplayName</PropertyName>
              </ListItem>
            </ListItems>
          </ListEntry>
        </ListEntries>
      </ListControl>
    </View>

    <!-- Data Collector -->


   <View>
      <Name>CollectionSet</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Collector.CollectionSet</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>IsRunning</Label>
            <Width>10</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>36</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsRunning</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

   <View>
      <Name>CollectionItem</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Collector.CollectionItem</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Collector Type</Label>
            <Width>27</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Collection Frequency</Label>
            <Width>21</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>CollectionFrequency</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <!-- SQL Server Provider Types -->

    <View>
      <Name>SqlServerProviderExtension</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.PowerShell.Extensions.SqlServerProviderExtension</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>15</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Root</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Root</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Machine</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.PowerShell.Extensions.Machine</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>MachineName</Label>
            <Width>32</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>MachineName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>


    <View>
      <Name>CollectionInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Sdk.Sfc.CollectionInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>60</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <!-- Extended Events -->
    <View>
      <Name>XEStore</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.XEStore</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Total Session Count</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Running Session Count</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.Sessions.Count</ScriptBlock>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>RunningSessionCount</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Session</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Session</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>AutoStartUp</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>IsRunning</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Start Time</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>AutoStart</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsRunning</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <ScriptBlock>$_.StartTime.ToString("g")</ScriptBlock>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Event</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Event</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Package Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Predicate</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PackageName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PredicateExpression</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Target</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Target</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Package Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PackageName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>EventField</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.EventField</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TargetField</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.TargetField</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
    <View>
      <Name>Action</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Action</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Package Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>PackageName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
    <View>
      <Name>Package</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.Package</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>ID</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


          <TableColumnHeader>
            <Label>Module ID</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>ID</PropertyName>
              </TableColumnItem>
             
              <TableColumnItem>
                <PropertyName>ModuleID</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>EventInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.EventInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Capabilities</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>CapabilitiesDesc</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>EventColumnInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.EventColumnInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DataEventColumnInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.DataEventColumnInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ReadOnlyEventColumnInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.ReadOnlyEventColumnInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ActionInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.ActionInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Action Name</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TargetInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.TargetInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TargetColumnInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.TargetColumnInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>


              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>TypeInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.TypeInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Type Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type Size</Label>
            <Width>10</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>


        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Size</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MapInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.MapInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MapValueInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.MapValueInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Value</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Value</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
    <View>
      <Name>PredSourceInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.PredSourceInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>PredCompareInfo</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.XEvent.PredCompareInfo</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Type</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Description</Label>
            <Width>40</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TypeName</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Description</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <!-- Utility -->
    <View>
      <Name>Utility</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.Utility</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>80</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

   <View>
      <Name>Computer</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.Computer</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Clustered</Label>
            <Width>27</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>IsClustered</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Volume</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.Volume</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Mount Point</Label>
            <Width>12</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
          <TableColumnHeader>
            <Label>Space Utilization %</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Total Space</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Total Space Used</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>
          
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>MountPointLocation</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TotalSpaceUtilization</PropertyName>
              </TableColumnItem>
              
              <TableColumnItem>
                <PropertyName>TotalSpace</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>TotalSpaceUsed</PropertyName>
              </TableColumnItem>
              
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Processor</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.Processor</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Processor Name</Label>
            <Width>16</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Architecture</Label>
            <Width>18</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Clock Speed</Label>
            <Width>20</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Architecture</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>ClockSpeed</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
    <View>
      <Name>ImportedObject</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Utility.ImportedObject</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>

          <TableColumnHeader>
            <Label>Name</Label>
            <Width>30</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

          <TableColumnHeader>
            <Label>Version</Label>
            <Width>27</Width>
            <Alignment>left</Alignment>
          </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>

              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>

              <TableColumnItem>
                <PropertyName>Version</PropertyName>
              </TableColumnItem>

            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

  <!-- DAC -->

  <View>
      <Name>DAC</Name>
      <ViewSelectedBy>
          <TypeName>Microsoft.SqlServer.Management.DAC.DacStore</TypeName>
      </ViewSelectedBy>
      <TableControl>
          <TableHeaders>

              <TableColumnHeader>
                  <Label>Name</Label>
                  <Width>80</Width>
                  <Alignment>left</Alignment>
              </TableColumnHeader>

          </TableHeaders>
          <TableRowEntries>
              <TableRowEntry>
                  <TableColumnItems>

                      <TableColumnItem>
                          <PropertyName>Name</PropertyName>
                      </TableColumnItem>

                  </TableColumnItems>
              </TableRowEntry>
          </TableRowEntries>
      </TableControl>
  </View>
  <View>
    <Name>DacPackage</Name>
    <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.DAC.DacInstance</TypeName>
    </ViewSelectedBy>
    <TableControl>
        <TableHeaders>

            <TableColumnHeader>
                <Label>Instance Name</Label>
                <Width>30</Width>
                <Alignment>left</Alignment>
            </TableColumnHeader>

            <TableColumnHeader>
                <Label>Application Name</Label>
                <Width>30</Width>
                <Alignment>left</Alignment>
            </TableColumnHeader>

            <TableColumnHeader>
                <Label>Application Version</Label>
                <Width>27</Width>
                <Alignment>left</Alignment>
            </TableColumnHeader>

        </TableHeaders>
        <TableRowEntries>
            <TableRowEntry>
                <TableColumnItems>

                    <TableColumnItem>
                        <PropertyName>Name</PropertyName>
                    </TableColumnItem>

                    <TableColumnItem>
                        <ScriptBlock>$_.Type.Name</ScriptBlock>
                    </TableColumnItem>

                    <TableColumnItem>
                        <ScriptBlock>$_.Type.Version</ScriptBlock>
                    </TableColumnItem>

                </TableColumnItems>
            </TableRowEntry>
        </TableRowEntries>
    </TableControl>
  </View>

  <!-- AlwaysOn -->
  <View>
    <Name>AvailabilityDatabase</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityDatabase</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>Name</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>SynchronizationState</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>IsSuspended</Label>
          <Width>11</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>IsJoined</Label>
          <Width>8</Width>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>SynchronizationState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>IsSuspended</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <ScriptBlock>$_.IsJoined -eq 1</ScriptBlock>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>AvailabilityGroup</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityGroup</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>Name</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>PrimaryReplicaServerName</Label>
          <Width>32</Width>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>PrimaryReplicaServerName</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>AvailabilityReplica</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityReplica</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>Name</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Role</Label>
          <Width>9</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>ConnectionState</Label>
          <Width>15</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>RollupSynchronizationState</Label>
          <Width>26</Width>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Role</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>ConnectionState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>RollupSynchronizationState</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>DatabaseReplicaState</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.Smo.DatabaseReplicaState</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>AvailabilityReplicaServerName</Label>
          <Width>29</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>AvailabilityDatabaseName</Label>
          <Width>24</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>SynchronizationState</Label>
          <Width>21</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>EstimatedRecoveryTime</Label>
          <Width>24</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>SynchronizationPerformance</Label>
          <Width>26</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>LogSendQueueSize</Label>
          <Width>16</Width>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>AvailabilityReplicaServerName</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>AvailabilityDatabaseName</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>SynchronizationState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>EstimatedRecoveryTime</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>SynchronizationPerformance</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>LogSendQueueSize</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>DatabaseReplicaHealthState</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.PowerShell.Hadr.DatabaseReplicaHealthState</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>HealthState</Label>
          <Width>22</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>AvailabilityGroup</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>AvailabilityReplica</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Name</Label>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>HealthState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>AvailabilityGroup</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>AvailabilityReplica</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>AvailabilityReplicaHealthState</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.PowerShell.Hadr.AvailabilityReplicaHealthState</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>HealthState</Label>
          <Width>22</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>AvailabilityGroup</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Name</Label>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>HealthState</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>AvailabilityGroup</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>AvailabilityGroupHealthState</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.PowerShell.Hadr.AvailabilityGroupHealthState</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>HealthState</Label>
          <Width>22</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Name</Label>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
              <TableColumnItem>
                <PropertyName>HealthState</PropertyName>           
              </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

  <View>
    <Name>PolicyEvaluationDetails</Name>
    <ViewSelectedBy>
      <TypeName>Microsoft.SqlServer.Management.PowerShell.Hadr.PolicyEvaluationDetails</TypeName>
    </ViewSelectedBy>
    <TableControl>
      <TableHeaders>
        <TableColumnHeader>
          <Label>Result</Label>
          <Width>6</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>TargetObject</Label>
          <Width>20</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Category</Label>
          <Width>35</Width>
        </TableColumnHeader>
        <TableColumnHeader>
          <Label>Name</Label>
        </TableColumnHeader>
      </TableHeaders>
      <TableRowEntries>
        <TableRowEntry>
          <TableColumnItems>
            <TableColumnItem>
              <PropertyName>Result</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>TargetObject</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Category</PropertyName>
            </TableColumnItem>
            <TableColumnItem>
              <PropertyName>Name</PropertyName>
            </TableColumnItem>
          </TableColumnItems>
        </TableRowEntry>
      </TableRowEntries>
    </TableControl>
  </View>

    <View>
      <Name>AvailabilityGroupListener</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityGroupListener</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>PortNumber</Label>
            <Width>15</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>ClusterIPConfiguration</Label>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <wrap />
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>PortNumber</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ClusterIPConfiguration</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>AvailabilityGroupListenerIPAddress</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.SqlServer.Management.Smo.AvailabilityGroupListenerIPAddress</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>IsDhcp</Label>
            <Width>6</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>SubnetMask</Label>
            <Width>20</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>IPAddress</Label>
            <Width>40</Width>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>IsDHCP</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>SubnetMask</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>IPAddress</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>IPAddressState</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>
    
  <!-- Analysis Services Provider - SQLAS -->

    <View>
      <Name>AnalysisServerHost</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.PowerShell.Provider.AnalysisServerHost</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Host Name</Label>
            <Width>80</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MajorObjectCollection</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MajorObjectCollection</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Collections</Label>
            <Width>80</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>DisplayName</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ASServer</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Server</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Instance Name</Label>
            <Width>80</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <!-- DisplayName may not be available when servers are retrieved using AnalysisServerHost.AnalysisServers property -->
                <ScriptBlock>
                  if ([string]::IsNullOrEmpty($_.DisplayName)) { $_.Name }
                  else { $_.DisplayName }
                </ScriptBlock>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>ASDatabase</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Database</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read-Write Mode</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ReadWriteMode</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Cube</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Cube</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Processing Mode</Label>
            <Width>16</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Last Processed On</Label>
            <Width>17</Width>
            <Alignment>Right</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ProcessingMode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <ScriptBlock>$_.LastProcessed.ToString("g")</ScriptBlock>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MeasureGroup</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MeasureGroup</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Type</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Processing Mode</Label>
            <Width>16</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Type</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ProcessingMode</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>AggregateDesign</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.AggregationDesign</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>60</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Estimated Rows</Label>
            <Width>20</Width>
            <Alignment>Right</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>EstimatedRows</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Partition</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Partition</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Aggregation Design ID</Label>
            <Width>21</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Estimated Rows</Label>
            <Width>14</Width>
            <Alignment>Right</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Processing Mode</Label>
            <Width>16</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Type</Label>
            <Width>10</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Storage Mode</Label>
            <Width>12</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>AggregationDesignID</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>EstimatedRows</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ProcessingMode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Type</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>CurrentStorageMode</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Dimension</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Dimension</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>35</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Processing Mode</Label>
            <Width>16</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Current Storage Mode</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ProcessingMode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>CurrentStorageMode</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DimensionPermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DimensionPermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Assembly</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Assembly</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>60</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Loaded State</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>IsLoaded</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DatabasePermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DatabasePermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Role</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Role</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>60</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Created On</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <ScriptBlock>$_.CreatedTimeStamp.ToSTring("g")</ScriptBlock>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MiningStructure</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MiningStructure</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Collation</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Cache Mode</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Collation</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>CacheMode</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MiningModel</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MiningModel</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>State</Label>
            <Width>18</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Algorithm</Label>
            <Width>28</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>AllowDrillThrough</Label>
            <Width>17</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>State</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Algorithm</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>AllowDrillThrough</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MiningModelPermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MiningModelPermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MiningStructurePermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MiningStructurePermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Trace</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Trace</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Log File Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Log File Size</Label>
            <Width>13</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Auto Restart</Label>
            <Width>12</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>LogFileName</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>LogFileSize</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>AutoRestart</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>MdxScript</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.MdxScript</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Default Script</Label>
            <Width>17</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Created Timestamp</Label>
            <Width>20</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>DefaultScript</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <ScriptBlock>$_.CreatedTimestamp.ToSTring("g")</ScriptBlock>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>Perspective</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.Perspective</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>KPIs</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Dimensions</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>MeasureGroups</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Kpis</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Dimensions</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>MeasureGroups</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>CubePermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.CubePermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DataSource</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DataSource</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>25</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Isolation</Label>
            <Width>13</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Max Connections</Label>
            <Width>15</Width>
            <Alignment>Right</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Connection String</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <Wrap/>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Isolation</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>MaxActiveConnections</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>ConnectionString</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DataSourcePermission</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DataSourcePermission</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>50</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Read Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Write Access</Label>
            <Width>15</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Read</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>Write</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

    <View>
      <Name>DataSourceView</Name>
      <ViewSelectedBy>
        <TypeName>Microsoft.AnalysisServices.DataSourceView</TypeName>
      </ViewSelectedBy>
      <TableControl>
        <TableHeaders>
          <TableColumnHeader>
            <Label>Name</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
          <TableColumnHeader>
            <Label>Primary Data Source</Label>
            <Width>40</Width>
            <Alignment>Left</Alignment>
          </TableColumnHeader>
        </TableHeaders>
        <TableRowEntries>
          <TableRowEntry>
            <TableColumnItems>
              <TableColumnItem>
                <PropertyName>Name</PropertyName>
              </TableColumnItem>
              <TableColumnItem>
                <PropertyName>DataSource</PropertyName>
              </TableColumnItem>
            </TableColumnItems>
          </TableRowEntry>
        </TableRowEntries>
      </TableControl>
    </View>

  </ViewDefinitions>
</Configuration>

<!-- SIG # Begin signature block -->
<!-- MIIbHwYJKoZIhvcNAQcCoIIbEDCCGwwCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB -->
<!-- gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR -->
<!-- AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUueOoT00xoBxWmTp4sIsHQtTZ -->
<!-- up2gghXyMIIEoDCCA4igAwIBAgIKYRr16gAAAAAAajANBgkqhkiG9w0BAQUFADB5 -->
<!-- MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk -->
<!-- bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN -->
<!-- aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xMTExMDEyMjM5MTdaFw0xMzAy -->
<!-- MDEyMjQ5MTdaMIGDMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ -->
<!-- MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u -->
<!-- MQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24w -->
<!-- ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDDqR/PfCN/MR4GJYnddXm5 -->
<!-- z5NLYZK2lfLvqiWdd/NLWm1JkMzgMbimAjeHdK/yrKBglLjHTiX+h9hY0iBOLfE6 -->
<!-- ZS6SW6Zd5pV14DTlUCGcfTmXto5EI2YWpmUg4Dbrivqd4stgAfwqZMiHRRTxHsrN -->
<!-- KKy65VdZJtzsxUpsmuYDGikyPwCeg6wlDYTM3W+2arst94Q6bWYx6DZw/4SSkPdA -->
<!-- dp6ILkfWKxH3j+ASZSu8X+8V/PfsAWi3RQzuwASwDre9eGuujeRQ8TXingHS4etb -->
<!-- cYJhISDz1MneHLgCRWVJvn61N4anzexa37h2IPwRE1H8+ipQqrQe0DqAvmPK3IFH -->
<!-- AgMBAAGjggEdMIIBGTATBgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUAAOm -->
<!-- 5aLEcaKCw492zSwNEuKdSigwDgYDVR0PAQH/BAQDAgeAMB8GA1UdIwQYMBaAFFdF -->
<!-- dBxdsPbIQwXgjFQtjzKn/kiWMFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwu -->
<!-- bWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY0NvZFNpZ1BDQV8wOC0z -->
<!-- MS0yMDEwLmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93 -->
<!-- d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljQ29kU2lnUENBXzA4LTMxLTIw -->
<!-- MTAuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCQ9/h5kmnIj2uKYO58wa4+gThS9LrP -->
<!-- mYzwLT0T9K72YfB1OE5Zxj8HQ/kHfMdT5JFi1qh2FHWUhlmyuhDCf2wVPxkVww4v -->
<!-- fjnDz/5UJ1iUNWEHeW1RV7AS4epjcooWZuufOSozBDWLg94KXjG8nx3uNUUNXceX -->
<!-- 3yrgnX86SfvjSEUy3zZtCW52VVWsNMV5XW4C1cyXifOoaH0U6ml7C1V9AozETTC8 -->
<!-- Yvd7peygkvAOKg6vV5spSM22IaXqHe/cCfWrYtYN7DVfa5nUsfB3Uvl36T9smFbA -->
<!-- XDahTl4Q9Ix6EZcgIDEIeW5yFl8cMFeby3yiVfVwbHjsoUMgruywNYsYMIIEujCC -->
<!-- A6KgAwIBAgIKYQUTNgAAAAAAGjANBgkqhkiG9w0BAQUFADB3MQswCQYDVQQGEwJV -->
<!-- UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE -->
<!-- ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGlt -->
<!-- ZS1TdGFtcCBQQ0EwHhcNMTEwNzI1MjA0MjE3WhcNMTIxMDI1MjA0MjE3WjCBszEL -->
<!-- MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v -->
<!-- bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9Q -->
<!-- UjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjE1OUMtQTNGNy0yNTcwMSUwIwYD -->
<!-- VQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNlMIIBIjANBgkqhkiG9w0B -->
<!-- AQEFAAOCAQ8AMIIBCgKCAQEAnDSYGckJKWOZAhZ1qIhXfaG7qUES/GSRpdYFeL93 -->
<!-- 3OzmrrhQTsDjGr3tt/34IIpxOapyknKfignlE++RQe1hJWtRre6oQ7VhQiyd8h2x -->
<!-- 0vy39Xujc3YTsyuj25RhgFWhD23d2OwW/4V/lp6IfwAujnokumidj8bK9JB5euGb -->
<!-- 7wZdfvguw2oVnDwUL+fVlMgiG1HLqVWGIbda80ESOZ/wValOqiUrY/uRcjwPfMCW -->
<!-- ctzBo8EIyt7FybXACl+lnAuqcgpdCkB9LpjQq7KIj4aA6H3RvlVr4FgsyDY/+eYR -->
<!-- w/BDBYV4AxflLKcpfNPilRcAbNvcrTwZOgLgfWLUzvYdPQIDAQABo4IBCTCCAQUw -->
<!-- HQYDVR0OBBYEFPaDiyCHEe6Dy9vehaLSaIY3YXSQMB8GA1UdIwQYMBaAFCM0+NlS -->
<!-- RnAK7UD7dvuzK7DDNbMPMFQGA1UdHwRNMEswSaBHoEWGQ2h0dHA6Ly9jcmwubWlj -->
<!-- cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY3Jvc29mdFRpbWVTdGFtcFBD -->
<!-- QS5jcmwwWAYIKwYBBQUHAQEETDBKMEgGCCsGAQUFBzAChjxodHRwOi8vd3d3Lm1p -->
<!-- Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFRpbWVTdGFtcFBDQS5jcnQw -->
<!-- EwYDVR0lBAwwCgYIKwYBBQUHAwgwDQYJKoZIhvcNAQEFBQADggEBAGL0BQ1P5xtr -->
<!-- gudSDN95jKhVgTOX06TKyf6vSNt72m96KE/H0LeJ2NGmmcyRVgA7OOi3Mi/u+c9r -->
<!-- 2Zje1gL1QlhSa47aQNwWoLPUvyYVy0hCzNP9tPrkRIlmD0IOXvcEnyNIW7SJQcTa -->
<!-- bPg29D/CHhXfmEwAxLLs3l8BAUOcuELWIsiTmp7JpRhn/EeEHpFdm/J297GOch2A -->
<!-- djw2EUbKfjpI86/jSfYXM427AGOCnFejVqfDbpCjPpW3/GTRXRjCCwFQY6f889GA -->
<!-- noTjMjTdV5VAo21+2usuWgi0EAZeMskJ6TKCcRan+savZpiJ+dmetV8QI6N3gPJN -->
<!-- 1igAclCFvOUwggYHMIID76ADAgECAgphFmg0AAAAAAAcMA0GCSqGSIb3DQEBBQUA -->
<!-- MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFgltaWNyb3Nv -->
<!-- ZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0 -->
<!-- eTAeFw0wNzA0MDMxMjUzMDlaFw0yMTA0MDMxMzAzMDlaMHcxCzAJBgNVBAYTAlVT -->
<!-- MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK -->
<!-- ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xITAfBgNVBAMTGE1pY3Jvc29mdCBUaW1l -->
<!-- LVN0YW1wIFBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJ+hbLHf -->
<!-- 20iSKnxrLhnhveLjxZlRI1Ctzt0YTiQP7tGn0UytdDAgEesH1VSVFUmUG0KSrphc -->
<!-- MCbaAGvoe73siQcP9w4EmPCJzB/LMySHnfL0Zxws/HvniB3q506jocEjU8qN+kXP -->
<!-- CdBer9CwQgSi+aZsk2fXKNxGU7CG0OUoRi4nrIZPVVIM5AMs+2qQkDBuh/NZMJ36 -->
<!-- ftaXs+ghl3740hPzCLdTbVK0RZCfSABKR2YRJylmqJfk0waBSqL5hKcRRxQJgp+E -->
<!-- 7VV4/gGaHVAIhQAQMEbtt94jRrvELVSfrx54QTF3zJvfO4OToWECtR0Nsfz3m7IB -->
<!-- ziJLVP/5BcPCIAsCAwEAAaOCAaswggGnMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O -->
<!-- BBYEFCM0+NlSRnAK7UD7dvuzK7DDNbMPMAsGA1UdDwQEAwIBhjAQBgkrBgEEAYI3 -->
<!-- FQEEAwIBADCBmAYDVR0jBIGQMIGNgBQOrIJgQFYnl+UlE/wq4QpTlVnkpKFjpGEw -->
<!-- XzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkWCW1pY3Jvc29m -->
<!-- dDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5 -->
<!-- ghB5rRahSqClrUxzWPQHEy5lMFAGA1UdHwRJMEcwRaBDoEGGP2h0dHA6Ly9jcmwu -->
<!-- bWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL21pY3Jvc29mdHJvb3RjZXJ0 -->
<!-- LmNybDBUBggrBgEFBQcBAQRIMEYwRAYIKwYBBQUHMAKGOGh0dHA6Ly93d3cubWlj -->
<!-- cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljcm9zb2Z0Um9vdENlcnQuY3J0MBMGA1Ud -->
<!-- JQQMMAoGCCsGAQUFBwMIMA0GCSqGSIb3DQEBBQUAA4ICAQAQl4rDXANENt3ptK13 -->
<!-- 2855UU0BsS50cVttDBOrzr57j7gu1BKijG1iuFcCy04gE1CZ3XpA4le7r1iaHOEd -->
<!-- AYasu3jyi9DsOwHu4r6PCgXIjUji8FMV3U+rkuTnjWrVgMHmlPIGL4UD6ZEqJCJw -->
<!-- +/b85HiZLg33B+JwvBhOnY5rCnKVuKE5nGctxVEO6mJcPxaYiyA/4gcaMvnMMUp2 -->
<!-- MT0rcgvI6nA9/4UKE9/CCmGO8Ne4F+tOi3/FNSteo7/rvH0LQnvUU3Ih7jDKu3hl -->
<!-- XFsBFwoUDtLaFJj1PLlmWLMtL+f5hYbMUVbonXCUbKw5TNT2eb+qGHpiKe+imyk0 -->
<!-- BncaYsk9Hm0fgvALxyy7z0Oz5fnsfbXjpKh0NbhOxXEjEiZ2CzxSjHFaRkMUvLOz -->
<!-- sE1nyJ9C/4B5IYCeFTBm6EISXhrIniIh0EPpK+m79EjMLNTYMoBMJipIJF9a6lbv -->
<!-- pt6Znco6b72BJ3QGEe52Ib+bgsEnVLaxaj2JoXZhtG6hE6a/qkfwEm/9ijJssv7f -->
<!-- UciMI8lmvZ0dhxJkAj0tr1mPuOQh5bWwymO0eFQF1EEuUKyUsKV4q7OglnUa2ZKH -->
<!-- E3UiLzKoCG6gW4wlv6DvhMoh1useT8ma7kng9wFlb4kLfchpyOZu6qeXzjEp/w7F -->
<!-- W1zYTRuh2Povnj8uVRZryROj/TCCBoEwggRpoAMCAQICCmEVCCcAAAAAAAwwDQYJ -->
<!-- KoZIhvcNAQEFBQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixk -->
<!-- ARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNh -->
<!-- dGUgQXV0aG9yaXR5MB4XDTA2MDEyNTIzMjIzMloXDTE3MDEyNTIzMzIzMloweTEL -->
<!-- MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v -->
<!-- bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj -->
<!-- cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw -->
<!-- ggEKAoIBAQCfjd+FN4yxBlZmNk7UCus2I5Eer6uNWOnEz8GfOgokxMTEXrDuFRTF -->
<!-- +j6ZM2sZaXL0fAVf5ZklRNc1GYqQ3CiOkAzv1ZBhrd7cGHAtg8lvr4Us+N25uTD9 -->
<!-- cXgcg/3IqbmCZw16uMEJwrwWl1c/HJjTadcwkJCQjTAf2CbUnnuI2eIJ7ZdJResE -->
<!-- UoF1e7i1IrguVrvXz6lOPAqDoqg6xa22AQ5qzyK0Ix9s1Sfnt37BtNUyrXklHEKG -->
<!-- 4p2F9FfaG1kvLSaSKcWz14WjnmBalOZ7nHtegjRLbf/U7ifQotzRkAzOfQ4VfIis -->
<!-- NMfAbJiESslEeWgo3yKDDbiKLEhh4v4RAgMBAAGjggIjMIICHzAQBgkrBgEEAYI3 -->
<!-- FQEEAwIBADAdBgNVHQ4EFgQUV0V0HF2w9shDBeCMVC2PMqf+SJYwCwYDVR0PBAQD -->
<!-- AgHGMA8GA1UdEwEB/wQFMAMBAf8wgZgGA1UdIwSBkDCBjYAUDqyCYEBWJ5flJRP8 -->
<!-- KuEKU5VZ5KShY6RhMF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/Is -->
<!-- ZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290IENlcnRpZmlj -->
<!-- YXRlIEF1dGhvcml0eYIQea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB -->
<!-- hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9taWNy -->
<!-- b3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjho -->
<!-- dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJvb3RD -->
<!-- ZXJ0LmNydDB2BgNVHSAEbzBtMGsGCSsGAQQBgjcVLzBeMFwGCCsGAQUFBwICMFAe -->
<!-- TgBDAG8AcAB5AHIAaQBnAGgAdAAgAKkAIAAyADAAMAA2ACAATQBpAGMAcgBvAHMA -->
<!-- bwBmAHQAIABDAG8AcgBwAG8AcgBhAHQAaQBvAG4ALjATBgNVHSUEDDAKBggrBgEF -->
<!-- BQcDAzANBgkqhkiG9w0BAQUFAAOCAgEAMLywIKRioKfvOSZhPdysxpnQhsQu9YMy -->
<!-- ZV4iPpvWhvjotp/Ki9Y7dQuhkT5M3WR0jEnyiIwYZ2z+FWZGuDpGQpfIkTfUJLHn -->
<!-- rNPqQRSDd9PJTwVfoxRSv5akLz5WWxB1zlPDzgVUabRlySSlD+EluBq5TeUCuVAe -->
<!-- T7OYDB2VAu4iWa0iywV0CwRFewRZ4NgPs+tM+GDdwnie0bqfa/fz7n5EEUDSvbqb -->
<!-- SxYIbqS+VeSmOBKjSPQcVXqKINF9/pHblI8vwntrpmSFT6PlLDQpXQu/9cc4L8Qg -->
<!-- xFYx9mnOhfgKkezQ1q66OAUM625PTJwDKaqi/BigKQwNXFxWI1faHJYNyCY2wUTL -->
<!-- 5eHmb4nnj+mYtXPTeOPtowE8dOVevGz2IYlnBeyXnbWx/a+m6XKlwzThL5/59Go5 -->
<!-- 4i0Eglv80JyufJ0R+ea1Uxl0ujlKOet9QrNKOzc9wkp7J5jn4k6bG0pUOGojN75q -->
<!-- t0ju6kINSSSRjrcELpdv5OdFu49N/WDZ11nC2IDWYDR7t6GTIP6BuKqlXAnpig2+ -->
<!-- KE1+1+gP7WV40TFfuWbb30LnC8wCB43f/yAGo0VltLMyjS6R4k20qcn6vGsEDrKf -->
<!-- 6p/epMkKlvSN99iYqPCFAghZpCCmLAsa8lIG7WnlZBgb4KOr3sp8FGFDuGX1NqNV -->
<!-- EytnLE0bMEwxggSXMIIEkwIBATCBhzB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMK -->
<!-- V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0 -->
<!-- IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWduaW5nIFBD -->
<!-- QQIKYRr16gAAAAAAajAJBgUrDgMCGgUAoIHEMBkGCSqGSIb3DQEJAzEMBgorBgEE -->
<!-- AYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMCMGCSqGSIb3DQEJ -->
<!-- BDEWBBQbWBKvyWelAHfaJPO8H4GHjOo8XDBkBgorBgEEAYI3AgEMMVYwVKA2gDQA -->
<!-- UwBRAEwAIABQAG8AdwBlAHIAcwBoAGUAbABsACAAcABzADEAeABtAGwAIABmAGkA -->
<!-- bABloRqAGGh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbTANBgkqhkiG9w0BAQEFAASC -->
<!-- AQCn8xKaEW2xxwKwjKdDGtlRiGbzBfIcv9wLT9qGWTgva9YZMgLYIaeEHaOmMFcx -->
<!-- 6JHfSpi+3afErzMllx7TqVVI2IZGIxORV/5kYqqUgHkMzLLPKiMaEwqEkMmqsQzs -->
<!-- sosEeaXBfJyin1pbmPedsYYMbN2raBANDWQrIx19W05CN2HGkSicoxDss0gMbH+a -->
<!-- muQWSXZD5wBYNtdm41NB+aZxy+2hgpkECs9KGYz/T4gn3+ECwepjnrrWCGJ4Ohgg -->
<!-- G7rA0VVlKiITV492vWRpJgQH60SJyCgZoBvx/2Zks1lHuPZTRLyILr9W+Cxccmkg -->
<!-- YkhIFEg1v/2BdWIHsnQJkbE+oYICHTCCAhkGCSqGSIb3DQEJBjGCAgowggIGAgEB -->
<!-- MIGFMHcxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH -->
<!-- EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xITAfBgNV -->
<!-- BAMTGE1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQQIKYQUTNgAAAAAAGjAHBgUrDgMC -->
<!-- GqBdMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTEx -->
<!-- MTIxNDE0NTA1NVowIwYJKoZIhvcNAQkEMRYEFApr4/sLFdh6WwSU3b5+W1UVESia -->
<!-- MA0GCSqGSIb3DQEBBQUABIIBADLKw9oSDfoITnAuPR7c2lUu3akHl4rDtczFbxby -->
<!-- Fx/3PdHpsDwAGGE/zqECeoJ0Wt1wDy7nvACmmyMMYjIsPCCp4DvlFjhQ3bsmlHHR -->
<!-- lxEZZ8jbCp6t+w+4iX+Jq1Zd8ehC0PL2Z8/2Vsx98LnNDWQuPp9A+Jf0kbfOA0nJ -->
<!-- 8UtvVGW6vBIaYvvwqqM1KFiZyr5g+ZYzzSl202XrQTltvaBTT7gjAolvyRFTds8b -->
<!-- XQdxHMDrmfj+is5iCJXYLHgUiezZuzG9PZHdVWsf9Wwsds6CWV5wxCIcYhmnnNLv -->
<!-- uM3uiAlwy2LQLz/WOEORF7AaJCbYmamdYrSU7xs5OBHqYCk= -->
<!-- SIG # End signature block -->
