/*
 * Decompiled with CFR 0.152.
 */
package msi.cll;

import java.util.LinkedList;
import msi.cll.AcquireLicenseResponse;
import msi.cll.ConfigInfo;
import msi.cll.DeviceCapabilityResponse;
import msi.cll.DeviceInfo;
import msi.cll.DeviceRequest;
import msi.cll.DeviceResponse;
import msi.cll.Entry;
import msi.cll.FeatureInfo;
import msi.cll.FeatureInfoCount;
import msi.cll.GetEntitlementResponse;
import msi.cll.QueryFeatureResponse;
import msi.cll.StatusResponse;

public class CommonClientLicensingInterface {
    private static final int GET_ENTITLEMENT_DETAILS_BATCH_SIZE = 2000;
    private static final int GET_DEVICES_QUERY_BATCH_SIZE = 500;
    private GetEntitlementResponse entitlementResponse = new GetEntitlementResponse();
    private DeviceResponse deviceResponse = new DeviceResponse();
    private DeviceInfo deviceInfo = new DeviceInfo();
    private AcquireLicenseResponse acquireLicenseResponse = new AcquireLicenseResponse();
    private StatusResponse statusResponse = new StatusResponse();
    private QueryFeatureResponse queryFeatureResponse = new QueryFeatureResponse();
    private LinkedList<Entry> deviceIdList = new LinkedList();
    private DeviceCapabilityResponse deviceCapabilityResponse = new DeviceCapabilityResponse();
    private long ccli_ref;

    public CommonClientLicensingInterface(ConfigInfo cfgInfo, DeviceInfo devInfo) {
        this.Initialize(cfgInfo, devInfo);
    }

    private void updateDevCapResponse(byte[] binResponse, int binResponseSize) {
        this.deviceCapabilityResponse.binaryResponseSize = binResponseSize;
        this.deviceCapabilityResponse.binaryResponse = new byte[binResponseSize];
        System.arraycopy(binResponse, 0, this.deviceCapabilityResponse.binaryResponse, 0, binResponseSize);
    }

    public QueryFeatureResponse queryFeaturesFromFNEServer(FeatureInfo featureInfo) {
        return this.queryFeaturesFromFNEServer(featureInfo, true);
    }

    public QueryFeatureResponse queryFeaturesFromFile(String filePath, FeatureInfo featureInfo) {
        return this.queryFeaturesFromFile(filePath, featureInfo, false);
    }

    public GetEntitlementResponse getEntitlementDetails(String entitlementId) {
        return this.getEntitlementDetails(entitlementId, 2000);
    }

    public LinkedList<Entry> getDevicesQuery(String activationId, String deviceId) {
        return this.getDevicesQuery(activationId, deviceId, 500);
    }

    private native void Initialize(ConfigInfo var1, DeviceInfo var2);

    public final native void Dispose();

    public final native GetEntitlementResponse getEntitlementDetails(String var1, int var2);

    public final native DeviceResponse activateDevice(DeviceRequest var1, int var2);

    public final native boolean deactivateDevice(DeviceInfo var1);

    public final native DeviceResponse refreshDevice(DeviceRequest var1);

    public final native AcquireLicenseResponse acquireLicense(FeatureInfoCount var1);

    public final native StatusResponse releaseLicense(AcquireLicenseResponse var1);

    public final native QueryFeatureResponse queryFeatures(FeatureInfo var1);

    public final native QueryFeatureResponse queryFeaturesFromFNEServer(FeatureInfo var1, boolean var2);

    public final native DeviceResponse processOfflineResponse(String var1);

    public final native StatusResponse sendUsageInfo(DeviceRequest var1);

    public final native DeviceInfo getDeviceInfo();

    public final native int Error();

    public final native int ExtendedFlxError();

    public final native int ExtendedCllError();

    public final native DeviceCapabilityResponse sendRequestToFNOServer(DeviceRequest var1);

    public final native DeviceCapabilityResponse sendRefreshRequestToFNOServer(DeviceRequest var1);

    public final native QueryFeatureResponse queryFeaturesFromResponse(DeviceCapabilityResponse var1, FeatureInfo var2);

    public final native LinkedList<Entry> getDevicesQuery(String var1, String var2, int var3);

    public final native QueryFeatureResponse queryFeaturesFromFile(String var1, FeatureInfo var2, boolean var3);

    public final native boolean uploadOfflineResponseToFNEServer(String var1);

    public final native String getVersion();

    protected void finalize() {
        this.Dispose();
    }

    static {
        try {
            System.loadLibrary("JNICommonClientLicensingInterface");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("Couldn't load JNICommonClientLicensingInterface");
            System.out.println(e.getMessage());
        }
        System.out.println("***************loaded JNICommonClientLicensingInterface");
    }
}

